package gov.va.med.domain.service.messaging.transceiver;

import gov.va.med.domain.service.messaging.MessagingException;

/**
 * This interface is implemented by all classes that can be used as a Transceiver
 * In general, these classes should also implement:
 * 
 * 1) a default constructor
 * 2) a constructor that takes the EndPoint which is the container for 
 *    any required parameters that could control the message send such as
 *    JNDI info, IP Address, Proxy info, Credentials etc... depending on
 *    the requirements of the protocol used by the transceiver. 
 *     
 * @author Joel Goldberg  
 * @version $Id: ITransceiver.java,v 1.2 2005/05/23 14:42:25 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 *
 */
public interface ITransceiver {
    public Object transceive(Object payload) throws MessagingException;

}
